package macros.builders.s2

import macros.builders.s2.PersonBuilder2.*

case class Person private[s2] (firstName: String, lastName: String, email: String)

case class PersonBuilder2[
  F <: Option[String],
  L <: Option[String],
  E <: Option[String]
] private (
  private[s2] val fnOpt: F,
  private[s2] val lnOpt: L,
  private[s2] val emailOpt: E
) {
  private[s2] def setFirstName(fn: String): PersonBuilder2[Some[String], L, E] =
    copy[Some[String], L, E](fnOpt = Some(fn))

  private[s2] def setLastName(ln: String): PersonBuilder2[F, Some[String], E] =
    copy(lnOpt = Some(ln))

  private[s2] def setEmail(email: String): PersonBuilder2[F, L, Some[String]] =
    copy(emailOpt = Some(email))
}

object PersonBuilder2 {
  def apply(): PersonBuilder2[None.type, None.type, None.type] =
    new PersonBuilder2(None, None, None)

  implicit final class FirstNameOps(
    private val builder: PersonBuilder2[None.type, None.type, None.type]
  ) extends AnyVal {
    def firstName(value: String): PersonBuilder2[Some[String], None.type, None.type] =
      builder.setFirstName(value)
  }

  implicit final class LastNameOps(
    private val builder: PersonBuilder2[Some[String], None.type, None.type]
  ) extends AnyVal {
    def lastName(value: String): PersonBuilder2[Some[String], Some[String], None.type] =
      builder.setLastName(value)
  }

  implicit final class EmailOps(
    private val builder: PersonBuilder2[Some[String], Some[String], None.type]
  ) extends AnyVal {
    def email(value: String): PersonBuilder2[Some[String], Some[String], Some[String]] =
      builder.setEmail(value)
  }

  implicit final class BuildDoneOps(
    private val builder: PersonBuilder2[Some[String], Some[String], Some[String]]
  ) extends AnyVal {
    def build(): Person =
      Person(
        builder.fnOpt.value,
        builder.lnOpt.value,
        builder.emailOpt.value
      )
  }
}

@main
def buildPerson(): Unit = {
  println(
    PersonBuilder2()
      .firstName("Tom")
      .lastName("Hanks")
      //.email("tom@hanks.com")
      .build()
  )
}
