package macros.builders.s0

import macros.builders.s0.PersonBuilder.*

case class Person(name: String, age: Int, email: String)

class PersonBuilder[S <: Step] private (
  val name: String,
  val age: Int,
  val email: String
) {
  def name(name: String): PersonBuilder[S & Name] =
    new PersonBuilder(name, age, email)

  def age(age: Int): PersonBuilder[S & Age] =
    new PersonBuilder(name, age, email)

  def email(email: String): PersonBuilder[S & Email] =
    new PersonBuilder(name, age, email)

  def build()(implicit ev: S =:= CompletePerson): Person =
    Person(name, age, email)
}

object PersonBuilder {
  sealed trait Step
  sealed trait Empty extends Step
  sealed trait Name extends Step
  sealed trait Age extends Step
  sealed trait Email extends Step

  type CompletePerson = Empty & Name & Age & Email

  def apply(): PersonBuilder[Empty] = new PersonBuilder("", 0, "")

  def main(args: Array[String]): Unit = {
    val person =
      PersonBuilder()
        .name("John")
        .email("hello@world.com")
        //.age(30)
        .build() // Oops, we forgot to specify the age
  }
}
